"use strict";
assert2(cr, "cr namespace not created");
assert2(cr.plugins_, "cr.plugins_ not created");

cr.plugins_.Jalaali = function (runtime) {
    this.runtime = runtime;
};

/** TODO
Webservice Type : REST 
Url : api.geonames.org/timezone?
Parameters : lat,lng, radius (buffer in km for closest timezone in coastal areas),lang (for countryName), date (date for sunrise/sunset);
Result : the timezone at the lat/lng with gmt offset (1. January) and dst offset (1. July) 
Example http://api.geonames.org/timezone?lat=47.01&lng=10.2&username=demo 

This service is also available in JSON format : http://api.geonames.org/timezoneJSON?lat=47.01&lng=10.2&username=demo 


Element:
countryCode: ISO countrycode
countryName: name (language can be set with param lang)
timezoneId: name of the timezone (according to olson), this information is sufficient to work with the timezone and defines DST rules, consult the documentation of your development environment. Many programming environments include functions based on the olson timezoneId (example java TimeZone) 
time: the local current time
sunset: sunset local time (date)
sunrise: sunrise local time (date)
rawOffset: the amount of time in hours to add to UTC to get standard time in this time zone. Because this value is not affected by daylight saving time, it is called raw offset. 
gmtOffset: offset to GMT at 1. January (deprecated)
dstOffset: offset to GMT at 1. July (deprecated)

آدرس اصلی این ای‌پی‌آی
http://api.geonames.org/timezoneJSON?formatted=true&lat=32&lng=53&username=construct_jalaali&style=full


**/

(function () {
    var rt, JDate, isPersian = false, cYear;
    var pluginProto = cr.plugins_.Jalaali.prototype;
    
    JDate = require('jdate');
    cYear = new JDate()["getFullYear"]();
    
    function handleString(str) {
        if (typeof str !== "string") {
            str = str.toString();
        }
        if (isPersian) {
            for (var i=0, l=str.length; i < l; i++) {
                if (!isNaN(str.charAt(i)) && str.charAt(i) !== ' ')
                    str = str.substring(0, i) + PERSIAN_DIGITS[str.charAt(i)] + str.substring(i+1, l);
            }
        }
        str = str.replace('امرداد', 'مرداد');
        return str;
    };

    // Dictionary JSON Export
    function Export(data) {
        
        if (data == null)
            data = new JDate();
        
        if (data instanceof JDate || data instanceof Date) {
            data = {
                "year": data["getFullYear"](),
                "month": data["getMonth"](),
                "day": data["getDate"]()
            }

        }
        
        this.dictionary = {
            "c2dictionary": true,
            "data": {
                "year": data["year"],
                "month": data["month"],
                "day": data["day"]
            }
        };
        
//        this["setYear"] = function (year) {
//            this["dictionary"]["data"]["year"] = year;
//        };
//        
//        this["setMonth"] = function (month) {
//            this["dictionary"]["data"]["month"] = month;
//        };
//        
//        this["setDay"] = function (day) {
//            this["dictionary"]["data"]["day"] = day;
//        };
//        
//        this["get"] = function () {
//            return this["dictionary"];
//        };
        
        this["toString"] = function () {
            var newDic;
            if (isPersian) {
                newDic = JSON.parse(JSON.stringify(this.dictionary));
                for (var x in newDic["data"]) {
                    newDic["data"][x] = handleString(newDic["data"][x]);
                }
            } else {
                newDic = this.dictionary;
            }
            
            return JSON.stringify(newDic);
        };
    }

    // Object type class
    pluginProto.Type = function (plugin) {
        this.plugin = plugin;
        this.runtime = plugin.runtime;
        rt = plugin.runtime;
    };
    var typeProto = pluginProto.Type.prototype;
    typeProto.onCreate = function () {};

    // instance class
    pluginProto.Instance = function (type) {
        this.type = type;
        this.runtime = type.runtime;
        isPersian = true;
        
        
//        this.parseFormat = function(str) {
//            if (!str) return "";
//            var index = 0,
//                l = str.length,
//                char,
//                tIndex;
//            while (index < l) {
//                char = str.charAt(index);
//                tIndex = index;
//                ++index;
//                while (str.charAt(index) === char) {
//                    ++index;
//                }
//                
//            }
//        };
    };
    var instanceProto = pluginProto.Instance.prototype;
    instanceProto.onCreate = function () {
        if (this.properties[0] === 1) // if language is english
            isPersian = false;
    };


    // Conditions    
    pluginProto.cnds = {
        isLeapYear: function (year) {
            if (!year) year = cYear;
            return JDate["isLeapYear"](year);
        },
        IsPersian: function () {
            return isPersian;
        }
    };

    // Actions
    pluginProto.acts = {
        SetDigits: function (language) {
            isPersian = !language;
        }
    };
    
    pluginProto.exps = {
        Today: function (ret) {
            var today = new JDate();
            ret.set_string(new Export(null)["toString"]());
        },
        ToJalali: function (ret, year, month, day) {
            var d = new JDate(new Date(year, month, day));
            ret.set_string(new Export(d)["toString"]());
            
        },
        ToGregorian: function (ret, year, month, day) {
            var d = new JDate([year, month, day])["_d"];
            ret.set_string(new Export(d)["toString"]());
        },
        DaysInMonth: function (ret, year, month) {
            var days = JDate["daysInMonth"](year, month);
            if (isPersian) {
                days = handleString(days);
            }
            ret.set_any(days);
        },
        Format: function (ret, year, month, day, format) {
            ret.set_string(handleString(new JDate([year, month, day])["format"](format)));
        },
        FormatDictionary: function (ret, dic, format) {
            var d = JSON.parse(dic)["data"];
            ret.set_string(handleString(new JDate([d.year, d.month, d.day])["format"](format)));
        }
    };

})();
